<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class ValidateJsonFile implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        //check if the json_decode gets a valid array
        if (json_decode(file_get_contents($value))) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return __('The JSON file is invalid');
    }
}
